#ifndef LIB_FLUTTER_EMBEDDER_PLUGIN_REGISTRAR_H
#define LIB_FLUTTER_EMBEDDER_PLUGIN_REGISTRAR_H

#include <memory>
#include <string>
#include <vector>

#include "basic-message-channel.h"
#include "event-channel.h"
#include "export.h"
#include "message-codec-type.h"
#include "method-channel.h"
#include "method-codec-type.h"

class PluginInterface;

class EMBEDDER_EXPORT PluginRegistrar final
{
public:
    void RegisterMethodChannel(const std::string &channel,
                               MethodCodecType codec,
                               const MethodCallHandler &onMethod);

    void RegisterBasicMessageChannel(const std::string &channel,
                                     MessageCodecType codec,
                                     const MessageHandler &onMessage);

    void RegisterEventChannel(const std::string &channel,
                              MethodCodecType codec,
                              const EventHandler &onListen,
                              const EventHandler &onCancel);

private:
    friend class Application;
    void RegisterPlugin(std::shared_ptr<PluginInterface> plugin);

private:
    std::vector<std::shared_ptr<MethodChannel>> m_methodChannels;
    std::vector<std::shared_ptr<BasicMessageChannel>> m_messageChannels;
    std::vector<std::shared_ptr<EventChannel>> m_eventChannels;
    std::vector<std::shared_ptr<PluginInterface>> m_plugins;
};

#endif /* LIB_FLUTTER_EMBEDDER_PLUGIN_REGISTRAR_H */
