#ifndef LIB_FLUTTER_EMBEDDER_METHOD_CODEC_INTERFACE_H
#define LIB_FLUTTER_EMBEDDER_METHOD_CODEC_INTERFACE_H

#include "method-response.h"

struct DecodedMethodCall
{
    std::string method;
    Encodable args;
};

class IMethodCodec
{
public:
    virtual ~IMethodCodec() = default;

public:
    virtual DecodedMethodCall DecodeMethodCall(const std::vector<uint8_t> &data) const = 0;
    virtual std::vector<uint8_t> EncodeMethodCall(const DecodedMethodCall &call) const = 0;
    virtual MethodResponse DecodeMethodResponse(const std::vector<uint8_t> &data) const = 0;
    virtual std::vector<uint8_t> EncodeMethodResponse(const MethodResponse &response) const = 0;
};

#endif /* LIB_FLUTTER_EMBEDDER_METHOD_CODEC_INTERFACE_H */
