#ifndef LIB_FLUTTER_EMBEDDER_APPLICATION_H
#define LIB_FLUTTER_EMBEDDER_APPLICATION_H

#include <filesystem>
#include <glib.h>
#include <memory>
#include <thread>
#include <vector>

#include "export.h"
#include "plugin-registrar.h"

namespace application {
namespace detail {

struct Locale
{
    std::string language;
    std::string country;
};

} /* namespace detail */
} /* namespace application */

class EMBEDDER_EXPORT Application
{
public:
    static void Initialize(int argc, char *argv[]);
    static void Launch();
    static void SetPixelRatio(double pixelRatio);
    static void ForceUpdateWindowMetrics();
    static void RegisterPlugins(const std::vector<std::shared_ptr<PluginInterface>> &plugins);
    static void AttachEventSource(GSource *source);
    static std::string GetBinaryName();
    static double GetPixelRatio();

private:
    explicit Application(const std::string &binaryName);

    static Application *instance();
    static inline Application *m_instance = nullptr;

    std::string m_binaryName;
    std::vector<application::detail::Locale> m_locales;
    PluginRegistrar m_pluginRegistrar;
    double m_pixelRatio;
};

#endif /* LIB_FLUTTER_EMBEDDER_APPLICATION_H */
