// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause
import 'package:flutter/material.dart';
import 'package:wakelock_plus/wakelock_plus.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  bool _enabled = false;

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: const Text('Wakelock plus'),
        ),
        body: Padding(
          padding: const EdgeInsets.all(32.0),
          child: Column(
            children: [
              const Text(
                  'This plugin allows you to keep the device screen awake, i.e. prevent the screen from sleeping.'),
              const Divider(height: 36),
              Text(
                  'Sleep lock status of the device: ${_enabled ? 'ENABLED' : 'DISABLED'}'),
              const SizedBox(height: 16),
              if (!_enabled)
                ElevatedButton(
                  child: const Text('Enable'),
                  onPressed: () async {
                    await WakelockPlus.enable();
                    _enabled = await WakelockPlus.enabled;
                    setState(() {});
                  },
                ),
              if (_enabled)
                ElevatedButton(
                  child: const Text('Disable'),
                  onPressed: () async {
                    await WakelockPlus.disable();
                    _enabled = await WakelockPlus.enabled;
                    setState(() {});
                  },
                ),
            ],
          ),
        ),
      ),
    );
  }
}
