// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause
import 'package:flutter/material.dart';

/// List for body with separated items
class ListSeparated extends StatelessWidget {
  const ListSeparated({
    super.key,
    required this.children,
    this.controller,
    this.scroll = true,
  });

  final ScrollController? controller;
  final List<Widget> children;
  final bool scroll;

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      controller: controller ?? ScrollController(),
      child: SizedBox(
        width: MediaQuery.of(context).size.width,
        child: Padding(
          padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 16),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: children
                .map((e) => Column(children: [
              const SizedBox(height: 8),
              e,
              const SizedBox(height: 8),
            ]))
                .toList(),
          ),
        ),
      ),
    );
  }
}
