// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause
import 'package:flutter/material.dart';
import 'package:internal_aurora/list_item_info.dart';
import 'package:internal_aurora/theme/colors.dart';

class ListItemInfoResult extends StatelessWidget {
  final String text;
  final Color backgroundColor;

  const ListItemInfoResult(this.text, this.backgroundColor, {super.key});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      width: double.infinity,
      child: Card(
        color: backgroundColor,
        child: Padding(
          padding: const EdgeInsets.all(8),
          child: Text(
            text.replaceAll(RegExp(r"\s+"), ' ').replaceAll('\n', ' ').trim(),
            textAlign: TextAlign.center,
            style: const TextStyle(fontSize: 14, color: Colors.white),
          ),
        ),
      ),
    );
  }
}

class ListItemInfoSuccess extends ListItemInfo {
  const ListItemInfoSuccess(String text, {Key? key}) : super(text, key: key);

  @override
  Widget build(BuildContext context) {
    return ListItemInfoResult(text, InternalColors.green);
  }
}

class ListItemInfoError extends ListItemInfo {
  const ListItemInfoError(String text, {Key? key}) : super(text, key: key);

  @override
  Widget build(BuildContext context) {
    return ListItemInfoResult(text, InternalColors.red);
  }
}
