import 'dart:io';

import 'package:flutter_cache_manager/flutter_cache_manager.dart';
import 'package:flutter_cache_manager_example/main.dart';
import 'package:flutter_test/flutter_test.dart';

void main() {
  group('Flutter cache manager', () {
    testWidgets('Test flutter cache manager getSingleFile method', (tester) async {
      const urlFile = 'https://omprussia.gitlab.io/flutter/flutter/assets/images/install/preview_emulator_apps.png';
      final DefaultCacheManager impl = DefaultCacheManager();

      File file = await impl.getSingleFile(urlFile);

      expect(file.absolute, isNotNull);

      await tester.pumpWidget(const MyApp());
      await tester.pumpAndSettle();

      final finder = find.text(file.absolute.toString());

      expect(finder, findsOneWidget);
    });
  });
}
