// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import 'package:audioplayers/audioplayers.dart';
import 'package:audioplayers_aurora_example/components/player_widget.dart';
import 'package:audioplayers_aurora_example/components/stream_widget.dart';
import 'package:internal_aurora/list_item_data.dart';
import 'package:internal_aurora/list_item_info.dart';
import 'package:internal_aurora/list_separated.dart';
import 'package:internal_aurora/theme/colors.dart';
import 'package:internal_aurora/theme/theme.dart';
import 'package:flutter/material.dart';

void main() {
  runApp(const MaterialApp(home: MyApp()));
}

class MyApp extends StatefulWidget {
  const MyApp();

  @override
  _MyAppState createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  final player = AudioPlayer()..setReleaseMode(ReleaseMode.stop);
  final source = 'nasa_on_a_mission.mp3';

  @override
  void initState() {
    super.initState();
    player.setSourceAsset(source);
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      theme: internalTheme,
      home: Scaffold(
        appBar: AppBar(
          title: const Text('AudioPlayers example'),
        ),
        body: ListSeparated(
          children: [
            const ListItemInfo("""
            A Flutter plugin for AuroraOS to play multiple simultaneously audio files
            """),
            ListItemData(
              "Audioplayers",
              InternalColors.primary,
              description: """
              Asset MP3 2 (VBR):
              assets/nasa_on_a_mission.mp3
              """,
              builder: (value) {
                return Column(
                  children: [
                    Card(
                      child: PlayerWidget(player: player),
                    ),
                    Card(
                      child: StreamWidget(player: player),
                    ),
                  ],
                );
              },
            ),
          ],
        ),
      ),
    );
  }
}
