// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import 'package:audioplayers/audioplayers.dart';
import 'package:audioplayers_aurora_example/utils.dart';
import 'package:flutter/material.dart';

class StreamWidget extends StatefulWidget {
  final AudioPlayer player;

  const StreamWidget({
    required this.player,
    super.key,
  });

  @override
  State<StreamWidget> createState() => _StreamWidgetState();
}

class _StreamWidgetState extends State<StreamWidget> {
  Duration? streamDuration;
  Duration? streamPosition;
  PlayerState? streamState;

  AudioPlayer get player => widget.player;

  @override
  void initState() {
    super.initState();
    // Use initial values from player
    streamState = player.state;
    player.getDuration().then((it) => setState(() => streamDuration = it));
    player.getCurrentPosition().then(
          (it) => setState(() => streamPosition = it),
        );
    player.onDurationChanged
        .listen((it) => setState(() => streamDuration = it));
    player.onPositionChanged
        .listen((it) => setState(() => streamPosition = it));
    player.onPlayerStateChanged
        .listen((it) => setState(() => streamState = it));
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  void setState(VoidCallback fn) {
    // Subscriptions only can be closed asynchronously,
    // therefore events can occur after widget has been disposed.
    if (mounted) {
      super.setState(fn);
    }
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        const ListTile(title: Text('Streams')),
        ListTile(
          title: Text(
            streamDuration?.toString() ?? '-',
            key: const Key('onDurationText'),
          ),
          subtitle: const Text('Duration Stream'),
          leading: const Icon(Icons.timelapse),
        ),
        ListTile(
          title: Text(
            streamPosition?.toString() ?? '-',
            key: const Key('onPositionText'),
          ),
          subtitle: const Text('Position Stream'),
          leading: const Icon(Icons.timer),
        ),
        ListTile(
          title: Text(
            streamState?.toString() ?? '-',
            key: const Key('onStateText'),
          ),
          subtitle: const Text('State Stream'),
          leading: Icon(streamState?.getIcon() ?? Icons.stop),
        ),
      ],
    );
  }
}
