/* 
 * SPDX-FileCopyrightText: Copyright 2023 Alexander Syrykh,
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef FLUTTER_PLUGIN_AUDIOPLAYERS_AURORA_PLUGIN_H
#define FLUTTER_PLUGIN_AUDIOPLAYERS_AURORA_PLUGIN_H

#include <audioplayers_aurora/audio_player_stream_handler_impl.h>
#include <audioplayers_aurora/globals.h>
#include <audioplayers_aurora/gst_audio_player.h>

#include <flutter/basic_message_channel.h>
#include <flutter/encodable_value.h>
#include <flutter/event_channel.h>
#include <flutter/event_sink.h>
#include <flutter/event_stream_handler_functions.h>
#include <flutter/method_channel.h>
#include <flutter/plugin_registrar.h>
#include <flutter/standard_message_codec.h>
#include <flutter/standard_method_codec.h>

class PLUGIN_EXPORT AudioplayersAuroraPlugin final : public flutter::Plugin {
public:
    static void RegisterWithRegistrar(flutter::PluginRegistrar* registrar);

    void InitializeHandlers();

private:
    explicit AudioplayersAuroraPlugin(flutter::PluginRegistrar* plugin_registrar);

    void HandleMethodCall(const flutter::MethodCall<flutter::EncodableValue>& method_call,
                          std::unique_ptr<flutter::MethodResult<flutter::EncodableValue>> result);

    GstAudioPlayer* GetAudioPlayer(const std::string& player_id);

    void CreateAudioPlayer(const std::string& player_id);
    void InitializeEventChannel(const std::string& player_id);
    void InitializeAudioPlayer(const std::string& player_id);

    std::map<std::string, std::unique_ptr<GstAudioPlayer>> audio_players_;
    std::map<std::string, std::unique_ptr<flutter::EventSink<flutter::EncodableValue>>> event_sinks_;
    flutter::PluginRegistrar* registrar_;
};

#endif /* FLUTTER_PLUGIN_AUDIOPLAYERS_AURORA_PLUGIN_H */
