# audioplayers_aurora

The Aurora implementation of [audioplayers](https://pub.dev/packages/audioplayers) (used directly by gstreamer-1.0 without QT dependencies).

A Flutter plugin to play multiple simultaneously audio files.

## Usage

This package is not an _endorsed_ implementation of `audioplayers`.
Therefore, you have to include `audioplayers_aurora` alongside `audioplayers` as dependencies in your `pubspec.yaml` file.

**pubspec.yaml**

```yaml
dependencies:
  audioplayers: ^5.2.1
  audioplayers_aurora:
    git:
      url: https://gitlab.com/omprussia/flutter/flutter-plugins.git
      ref: @todo
      path: packages/audioplayers/audioplayers_aurora

```

***.desktop**

```desktop
Permissions=Audio
```

***.spec**

### Attention!!! Don't forget to install Aurora PSDK gstreamer 1.0. This package is not installed by default in the Aurora SDK, but it is necessary to build the plugin. But gstreamer 1.0 is present in Aurora OS on devices.

```spec
BuildRequires: pkgconfig(gstreamer-1.0)
```

***.dart**

```dart
import 'package:audioplayers/audioplayers.dart';
// ...
final player = AudioPlayer();
await player.play(UrlSource('https://example.com/my-audio.wav'));
```