// SPDX-FileCopyrightText: 2022 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include <QScopedPointer>
#include <QGuiApplication>
#include <QQuickView>
#include <QQmlContext>
#include <QDir>
#include <QFileInfo>
#include <QJsonDocument>
#include <QJsonObject>

#include <auroraapp.h>

#include "filesmodel.h"
#include "sortmodel.h"
#include "dbusadaptor.h"
#include "fileinfo.h"
#include "applicationsettings.h"
#include "fileutils.h"

int main(int argc, char *argv[])
{
    QScopedPointer<QGuiApplication> application(Aurora::Application::application(argc, argv));
    application->setOrganizationName(QStringLiteral("ru.auroraos"));
    application->setApplicationName(QStringLiteral("PdfViewer"));

    qmlRegisterType<FilesModel>("ru.auroraos.PdfViewer", 1, 0, "FilesModel");
    qmlRegisterType<SortModel>("ru.auroraos.PdfViewer", 1, 0, "SortModel");   
    qmlRegisterType<FileInfo>("ru.auroraos.PdfViewer", 1, 0, "FileInfo");
    DocumentSettings::registerSingleton("ru.auroraos.PdfViewer");
    FileUtils::registerSingleton("ru.auroraos.PdfViewer");

    if (!ApplicationSettings::singletonProvider().welcomeFileCopied()) {
        ApplicationSettings::singletonProvider().setWelcomeFileCopied(true);
        const QFileInfo fileInfoSource = QFileInfo(Aurora::Application::pathTo("data/welcome.pdf").toLocalFile());
        if (fileInfoSource.exists()) {
            const auto fileInfoDest = QFileInfo(QString("%1/%2/%3").arg(QDir::homePath(), QStringLiteral("Documents"), fileInfoSource.fileName()));
            const auto success = QFile::copy(fileInfoSource.absoluteFilePath(), fileInfoDest.absoluteFilePath());
            if (!success)
                qWarning("File %s is not copy!", fileInfoSource.fileName().toLocal8Bit().constData());
        }
    }

    QScopedPointer<QQuickView> view(Aurora::Application::createView());

    DBusAdaptor dbusAdaptor(view.data());
    view->rootContext()->setContextProperty(QStringLiteral("dbusAdaptor"), &dbusAdaptor);

    view->setSource(Aurora::Application::pathTo(QStringLiteral("qml/ru.auroraos.PdfViewer.qml")));
    view->show();

    return application->exec();
}
