// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include "fileutils.h"

#include <QtQml>
#include <QFileInfo>

static FileUtils *s_instance;

FileUtils::FileUtils(QObject *parent)
    : QObject(parent)
{}

void FileUtils::registerSingleton(const char *uri)
{
    qmlRegisterSingletonType<FileUtils>(uri, 1, 0, "FileUtils", FileUtils::singletonProvider);
}

QObject *FileUtils::singletonProvider(QQmlEngine *engine, QJSEngine *)
{
    if (!s_instance)
        s_instance = new FileUtils(engine);

    return s_instance;
}

QString FileUtils::absoluteFilePathFromUrl(const QUrl &url)
{
    const auto fileInfo = QFileInfo(url.toLocalFile());
    return fileInfo.absoluteFilePath();
}
