// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Page {
    id: root

    allowedOrientations: Orientation.All
    objectName: "navigationPage"

    property alias noteText: noteText.value
    property alias author: authorName.value
    property alias pageNumber: pageNumber.value
    property bool editable: false
    property string noteId
    property alias noteType: noteType.value
    property var color
    property var pdfPagesView

    AppBar {
        id: header

        iconContainer {
            radius: 100
            backgroundColor: color
        }
        headerText: qsTr("Note")

        AppBarSpacer {}

        AppBarButton {
            icon.source: "image://theme/icon-m-edit"
            visible: editable
            onClicked: {
                var createNotePage = pageStack.push(Qt.resolvedUrl("CreateNotePage.qml"), {
                                                              text: noteText.value,
                                                              color: root.color,
                                                              noteType: root.noteType
                                                          })
                createNotePage.onCreateNote.connect(function (text, color, newNoteType) {
                    root.color = color
                    noteText.value = text
                    noteType.value = newNoteType
                    pdfPagesView.editNote(root.pageNumber - 1, noteId, color, text, newNoteType)
                });
            }
        }
        AppBarButton {
            icon.source: "image://theme/icon-m-delete"
            visible: editable
            onClicked: {
                pdfPagesView.removeNote(root.pageNumber - 1, noteId);
                pageStack.pop();
            }
        }
    }

    Column {
        id: contentColumn

        objectName: "noteColumn"
        width: parent.width
        anchors {
            top: header.bottom
            margins: Theme.paddingLarge
        }

        DetailItem {
            id: noteText

            label: qsTr("Content")
            alignment: Qt.AlignLeft
            forceValueBelow: true
            palette {
                secondaryHighlightColor: Theme.secondaryColor
                highlightColor: Theme.primaryColor
            }
        }

        DetailItem {
            id: pageNumber

            label: qsTr("Page")
            alignment: Qt.AlignLeft
            forceValueBelow: true
            palette {
                secondaryHighlightColor: Theme.secondaryColor
                highlightColor: Theme.primaryColor
            }
        }

        DetailItem {
            id: authorName

            label: qsTr("Author name")
            alignment: Qt.AlignLeft
            forceValueBelow: true
            palette {
                secondaryHighlightColor: Theme.secondaryColor
                highlightColor: Theme.primaryColor
            }
        }

        DetailItem {
            id: noteType

            label: qsTr("Note type")
            alignment: Qt.AlignLeft
            forceValueBelow: true
            palette {
                secondaryHighlightColor: Theme.secondaryColor
                highlightColor: Theme.primaryColor
            }
        }
    }
}
