// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.auroraos.PdfViewer 1.0
import Aurora.Controls 1.0
import "../components"

Page {
    id: root

    allowedOrientations: Orientation.All

    property color color: "#e3e601"
    property string text: ""
    property string noteType
    readonly property var availableTypes: ["Square", "HighLight", "Text"]

    signal createNote(string text, color color, string noteType)

    Component.onCompleted: {
        if (noteType === "")
            noteTypeCombobox.currentIndex = 0
        else if (availableTypes.indexOf(noteType) !== -1)
            noteTypeCombobox.currentIndex = availableTypes.indexOf(noteType)
        else
            noteTypeCombobox.value = noteType
    }

    AppBar {
        id: header

        headerText: qsTr("Create new note")
        iconContainer {
            radius: 100
            backgroundColor: root.color
        }

        AppBarSpacer {}

        AppBarButton {
            onClicked: {
                var dialog = pageStack.push("Sailfish.Silica.ColorPickerDialog")
                dialog.accepted.connect(function() {
                    root.color = dialog.color
                })
            }
            icon.source: "image://theme/icon-m-edit"
        }

        AppBarButton {
            onClicked: {
                noteType = noteTypeCombobox.currentItem.text
                createNote(textField.text, root.color, noteType)
                pageStack.pop()
            }
            icon.source: "image://theme/icon-m-save"
        }
    }

    Column {
        width: parent.width
        anchors {
            top: header.bottom
            margins: Theme.paddingLarge
        }

        ComboBox {
            id: noteTypeCombobox

            width: parent.width
            label: qsTr("Note type")
            enabled: (availableTypes.indexOf(noteType) !== -1) || (noteType === "")
            menu: ContextMenu {
                MenuItem { text: "Square" }
                MenuItem { text: "HighLight" }
                MenuItem { text: "Text" }
            }
        }

        TextArea {
            id: textField

            text: root.text
            placeholderText: qsTr("Enter the note text")
        }
    }
}
