// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Item {
    id: contentHeader

    property bool visibleButtons
    property bool fullscreenMode
    property bool noteCreatingMode
    property alias title: appBar.headerText
    property bool opened: !fullscreenMode

    signal openDetails()
    signal fullscreenClicked()
    signal cancelNoteCreatingClicked()

    width: parent.width
    height: appBar.height
    y: fullscreenMode ? -height : 0

    enabled: !fullscreenMode

    Behavior on y {
        NumberAnimation {
            duration: 300
            easing.type: Easing.InOutQuad
        }
    }

    AppBar {
        id: appBar

        property bool visibleButtons: contentHeader.visibleButtons


        AppBarButton {
            id: cancelNoteCreatingButton

            onClicked: contentHeader.cancelNoteCreatingClicked()

            icon.source: "image://theme/icon-m-cancel"
            visible: noteCreatingMode
        }

        AppBarSpacer {}

        AppBarButton {
            id: fullscreenButton

            onClicked: contentHeader.fullscreenClicked()

            objectName: "FullscreenButton"
            icon.source: "image://theme/icon-splus-expand"
            visible: contentHeader.enabled && appBar.visibleButtons
        }

        AppBarButton {
            onClicked: contentHeader.openDetails()

            icon.source: "image://theme/icon-m-about"
            visible: appBar.visibleButtons
        }

        AppBarSpacer {
            visible: !appBar.visibleButtons
        }
    }
}
