// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFWORDMODEL_H
#define PDFWORDMODEL_H

#include <QAbstractListModel>
#include <QVector>
#include <basedocument.h>
#include <baseword.h>

struct BaseWord;
class PdfWordModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum PagePropertyRoles
    {
        ValueRole = Qt::UserRole + 1,
        PageIndexRole,
        InRect
    };

    explicit PdfWordModel(QObject *parent = nullptr);

    int rowCount(const QModelIndex &parent) const override;
    QVariant data(const QModelIndex &index, int role) const override;
    QHash<int, QByteArray> roleNames() const override;

    void setNewData(QString phrase, const QVector<BaseWord *> &newData);
    Q_INVOKABLE QString getPhrase();
    void clear();
private:
    QVector<BaseWord *> m_data;
    QString m_phrase;
};


#endif // PDFWORDMODEL_H
