// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFPHARSESEARCHWORKER_H
#define PDFPHARSESEARCHWORKER_H

#include <QObject>
#include <QRunnable>
#include <baseword.h>
#include <amberpdf/pdfdocument.h>
#include <pdfdocumentitem.h>


class PdfPhraseSearchWorker : public QObject, public QRunnable
{
    Q_OBJECT
public:
    PdfPhraseSearchWorker(QSharedPointer<PdfDocument> pdfiumDocument, QString phrase);
    void run() override;

signals:
    void done(QVector<BaseWord *>, QString);

private:
    QSharedPointer<PdfDocument> m_document;
    QString m_phrase;
};

#endif // PDFPHARSESEARCHWORKER_H
