// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include "pdfpharsesearchworker.h"

PdfPhraseSearchWorker::PdfPhraseSearchWorker(QSharedPointer<PdfDocument> document, QString phrase)
{
    this->m_document = document;
    this->m_phrase = phrase;
}

void PdfPhraseSearchWorker::run()
{
    QVector<BaseWord*> phrasesForModel;
    for (int i = 0; i < m_document->pageCount(); i++ ) {
        auto page = m_document->page(i);
        page.waitForFinished();
        auto wordsF = page.result()->words();
        wordsF.waitForFinished();
        auto words = wordsF.result();
        foreach (QObject *word, words) {
            PdfWord* casted = (PdfWord*)word;
            if ((casted)->value().toLower().trimmed() == m_phrase.toLower().trimmed()) {
                (casted)->setIndex(i);
                phrasesForModel.append(new BaseWord(casted->value(), casted->index(), casted->rect()));
            }
        }
    }
    emit done(phrasesForModel, m_phrase);
}

