// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFPHARSEHIGHLIGHTER_H
#define PDFPHARSEHIGHLIGHTER_H

#include <QObject>
#include <QRunnable>
#include <baseword.h>
#include <amberpdf/pdfdocument.h>
#include <pdfdocumentitem.h>


class PdfPhraseHighlighter : public QObject, public QRunnable
{
    Q_OBJECT
public:
    PdfPhraseHighlighter(QSharedPointer<PdfDocument> pdfiumDocument, QMap<int, QList<BaseWord*>> pagesToRehighlight);
    void run() override;

signals:
    void done();

private:
    QMap<int, QList<BaseWord*>> m_pagesToRehighlight;
    QSharedPointer<PdfDocument> m_pdfiumDocument;
};

#endif // PDFPHARSEHIGHLIGHTER_H
