// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include "pdfpharsehighlighter.h"

PdfPhraseHighlighter::PdfPhraseHighlighter(QSharedPointer<PdfDocument> pdfiumDocument, QMap<int, QList<BaseWord*>> pagesToRehighlight)
{
    this->m_pagesToRehighlight = pagesToRehighlight;
    m_pdfiumDocument = pdfiumDocument;
}

void PdfPhraseHighlighter::run()
{
    for (QMap<int, QList<BaseWord*>>::const_iterator it = m_pagesToRehighlight.cbegin(), end = m_pagesToRehighlight.cend(); it != end; ++it) {
         auto page = m_pdfiumDocument->page(it.key()).result();
         page->removeTextSearchResult().waitForFinished();
         foreach (BaseWord * phrase, it.value()) {
             page->addSearchResultAnnotation(phrase->rect, phrase->value);
         }
     }
    emit done();
}

