// SPDX-FileCopyrightText: 2022 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef BASEANNOTATION_H
#define BASEANNOTATION_H

#include <QRectF>
#include <QString>
#include <QColor>

static QList<QString> s_stringTypeValues = QList<QString>() << "Unknown" << "Link" << "Url" << "HighLight" << "Text" << "Square";

struct BaseAnnotation
{
public:
    enum class AnnotationType
    {
        Unknown = 0,
        Link,
        Url,
        HighLight,
        Text,
        Square
    };

    AnnotationType type;
    QRectF rect;
    QString author;
    QString content;
    int linkToPage;
    QPointF pageCoordinate;
    QColor color{Qt::white};
    int annotationId;
    bool isSearchResult;

    QString getTypeAsString() const;
};

#endif // BASEANNOTATION_H
