// SPDX-FileCopyrightText: 2022 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include <QUrl>
#include <QStringList>
#include <QDBusConnection>
#include <QDBusConnectionInterface>

#include "dbusadaptor.h"

DBusAdaptor::DBusAdaptor(QObject *parent) : QDBusAbstractAdaptor(parent)
{

    QDBusConnection dbusConnection = QDBusConnection::sessionBus();
    if (!dbusConnection.interface()->isServiceRegistered(QStringLiteral("ru.auroraos.PdfViewer"))) {
        dbusConnection.registerObject(QStringLiteral("/ru/auroraos/PdfViewer"), parent);
        dbusConnection.registerService(QStringLiteral("ru.auroraos.PdfViewer"));
    }
}

void DBusAdaptor::openFile(const QStringList &args)
{
    if (args.isEmpty())
        return;

    QString path;
    for (const auto &arg : args) {
        if (arg.isEmpty())
            continue;

        path = arg;
        break;
    }

    path = QUrl::fromPercentEncoding(path.toUtf8());
    path.remove(QStringLiteral("file://"));

    emit fileOpenRequested(path);
}
