import QtQuick 2.0
import Sailfish.Silica 1.0

Rectangle {
    property bool hasContentPage: pageStack.find(function (page) { return page.objectName === "contentPage" })

    color: "black"
    height: Theme.itemSizeMedium
    width: returnContent.width + 2 * Theme.horizontalPageMargin
    radius: height / 4.5

    Item {
        id: returnContent

        width: returnLabel.width + returnIcon.width
        height: parent.height
        anchors.centerIn: parent

        Label {
            id: returnLabel

            text: qsTr("Return to file")

            anchors {
                left: parent.left
                verticalCenter: parent.verticalCenter
            }
        }

        Image {
            id: returnIcon

            source: "../assets/icon-chevronRightCircle.svg"
            sourceSize: Qt.size(0.8 * Theme.iconSizeMedium, 0.8 * Theme.iconSizeMedium)

            anchors {
                left: returnLabel.right
                leftMargin: Theme.paddingSmall
                verticalCenter: parent.verticalCenter
            }
        }
    }

    MouseArea {
        anchors.fill: parent

        onClicked: {
            pageStack.pop();
        }
    }
}
