// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Item {
    id: contentHeader

    property bool visibleButtons
    property bool fullscreenMode
    property bool noteCreatingMode: false
    property alias title: appBar.headerText
    property bool opened: !fullscreenMode
    property bool isDrawing
    property bool isTextHighlighting: false
    property bool showNavigationButton

    signal openDetails()
    signal fullscreenClicked()
    signal cancelNoteCreatingClicked()
    signal nextSearchResultClicked()

    signal drawAccepted()
    signal drawDeclined()
    signal textHighlightAccepted()

    height: appBar.height
    y: fullscreenMode ? -height : 0

    enabled: !fullscreenMode

    anchors {
        left: parent.left
        right: parent.right
    }

    Behavior on y {
        NumberAnimation {
            duration: 300
            easing.type: Easing.InOutQuad
        }
    }

    IconButton {
        id: backNavigationButton

        visible: showNavigationButton
        icon.source: "../assets/icon-splus-back.svg"
        icon.sourceSize: Qt.size(Theme.iconSizeSmallPlus, Theme.iconSizeSmallPlus)
        width: showNavigationButton ? Theme.iconSizeSmallPlus : 0

        anchors {
            left: parent.left
            leftMargin: showNavigationButton ? Theme.paddingMedium : 0
            verticalCenter: parent.verticalCenter
        }

        onClicked: {
            pageStack.push(Qt.resolvedUrl("../pages/FilesPage.qml"), {}, PageStackAction.Immediate)
        }
    }

    Rectangle {
        y: appBar._bottomPosition ? 0 : Theme._itemSizeHeader - height
        width: parent.width
        height: Theme._lineWidth
        opacity: Theme.opacityFaint
        color: palette.primaryColor
    }

    AppBar {
        id: appBar

        property bool visibleButtons: contentHeader.visibleButtons

        anchors {
            right: parent.right
            left: backNavigationButton.right
        }

        AppBarButton {
            id: cancelNoteCreatingButton

            onClicked: contentHeader.cancelNoteCreatingClicked()

            icon.source: "image://theme/icon-m-cancel"
            visible: noteCreatingMode
        }

        AppBarButton {
            id: cancelTextHighlightButton

            onClicked: contentHeader.textHighlightAccepted()

            icon.source: "image://theme/icon-m-cancel"
            visible: root.isTextHighlighting && !root.isDrawingPageChosen
        }

        AppBarSpacer {}

        AppBarButton {
            id: fullscreenButton

            onClicked: contentHeader.fullscreenClicked()

            objectName: "FullscreenButton"
            icon.source: "image://theme/icon-splus-expand"
            visible: contentHeader.enabled && appBar.visibleButtons
        }

        AppBarButton {
            onClicked: contentHeader.openDetails()

            icon.source: "image://theme/icon-m-about"
            visible: appBar.visibleButtons
        }

        AppBarSpacer {
            visible: !appBar.visibleButtons
        }

        AppBarButton {
            onClicked: contentHeader.drawAccepted()

            icon.source: "image://theme/icon-m-accept"
            visible: contentHeader.isDrawing
        }

        AppBarButton {
            onClicked: contentHeader.drawDeclined()

            icon.source: "image://theme/icon-m-cancel"
            visible: root.isDrawing
        }

        AppBarButton {
            onClicked: contentHeader.textHighlightAccepted()

            icon.source: "image://theme/icon-m-accept"
            visible: contentHeader.isTextHighlighting
        }
    }
}
