// SPDX-FileCopyrightText: 2022-2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef SMOOTHLINE_H
#define SMOOTHLINE_H

#include <QObject>
#include <QPainter>

/*!
 * \brief Sources:
 * https://www.toptal.com/c-plus-plus/rounded-corners-bezier-curves-qpainter,
 * https://stackoverflow.com/questions/40764011/how-to-draw-a-smooth-curved-line-that-goes-through-several-points-in-qt
 */
class SmoothLine : public QObject
{
    Q_OBJECT
public:
    explicit SmoothLine(QList<QPointF> list, QObject *parent = nullptr);
    float distance(const QPointF &pt1, const QPointF &pt2);
    QPointF getLineStart(const QPointF &pt1, const QPointF &pt2);
    QPointF getLineEnd(const QPointF &pt1, const QPointF &pt2);
    QPainterPath getPath(QList<QPointF> list, qreal xOff, qreal yOff, const float &factor = 0);

private:
    QList<QPointF> m_list;

};

#endif // SMOOTHLINE_H
