// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include <QCryptographicHash>
#include <QStandardPaths>
#include <QFile>

#include "pdfdocumenthashworker.h"

/*!
 * \brief Default constructor that sets file path.
 * \param filePath Path to the file.
 */
PdfDocumentHashWorker::PdfDocumentHashWorker(const QString &filePath)
{
    this->m_filePath = filePath;
}

/*!
 * \brief Starts the process of creating hash for the given document.
 */
void PdfDocumentHashWorker::run()
{
    QFile file(m_filePath);
    if (file.open(QFile::ReadOnly)) {
        QCryptographicHash hash(QCryptographicHash::Sha256);
        if (hash.addData(&file)) {
            emit fileHashCounted(hash.result().toHex());
        }
    }
}
