// SPDX-FileCopyrightText: 2022 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef BASEPAGE_H
#define BASEPAGE_H

#include <QObject>
#include <QSizeF>
#include <QFuture>
#include <QPointF>

class BaseAnnotation;
class BasePage : public QObject
{
    Q_OBJECT

public:
    explicit BasePage(QObject *parent = nullptr);
    virtual ~BasePage();

    virtual QList<QSharedPointer<BaseAnnotation>> annotations() const = 0;
    virtual void loadAnnotations() = 0;
    virtual bool isAnnotationsSupport() const = 0;
    virtual int pageNumber() const = 0;
    virtual QString text() = 0;
    virtual QFuture<QSizeF> originalSize() = 0;
    virtual QFuture<QImage> bitmapFull(qreal pageScale, int renderFlags = 0) const = 0;
    virtual QFuture<QSharedPointer<QImage>> bitmapPart(qreal pageScaleX, qreal pageScaleY,
                                                       int renderFlags = 0, qreal zoom = 1.0,
                                                       const QPointF &bias = QPointF()) const = 0;
    virtual void addAnnotation(const QRectF &rect, const QColor &color,
                                       const QString &author, const QString &content, const QString &annotationType) = 0;
    virtual void drawInkAnnotation(const QRectF &rect, const QColor &color, const float penSize, const QList<QList<QPointF>> points, const QString &author, const QString &content) = 0;
    virtual void removeAnnotation(int annotationId) = 0;
    virtual void removeSearchResultAnnotations() = 0;
    virtual void editNote(int noteId, const QString &newContent, const QColor &newColor, const QString &annotationType) = 0;
    virtual void highlightText(QPoint startPoint, QPoint endPoint, QColor color) = 0;
    virtual QList<QRectF> findTextRects(QPoint startPoint, QPoint endPoint) = 0;

signals:
    void annotationsLoaded();
    void originalSizeLoaded();
    void annotationAdded(bool);
    void annotationDelete(int, bool);
    void annotationEdited(int, bool);
};

#endif // BASEPAGE_H
