/****************************************************************************
**
** Copyright (C) 2021 - 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PDFPAGERENDERTASK_H
#define PDFPAGERENDERTASK_H

#include <QPointF>
#include <QSizeF>
#include <QPointF>
#include <QImage>
#include <QFuture>
#include <QSharedPointer>

#include "pdftask.h"

struct fpdf_page_t__;
class PdfDocumentHolder;
class PdfPageRenderFullTask : public PdfTask
{
public:
    PdfPageRenderFullTask(float pageScale,
                      int renderFlags,
                      const QSizeF pageSize,
                      const QSharedPointer<fpdf_page_t__> &page,
                      const QSharedPointer<PdfDocumentHolder> &documentHolder,
                      const QFutureInterface<QImage> &interface);
    ~PdfPageRenderFullTask();

    void run() override;
    void cancel() override;
    int id() const override;

private:
    float m_pageScale;
    int m_renderFlags;
    QSizeF m_pageSize;
    QSharedPointer<fpdf_page_t__> m_page;
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    QFutureInterface<QImage> m_interface;
};

class PdfPageRenderPartTask : public PdfTask
{
public:
    PdfPageRenderPartTask(float pageScaleX,
                      float pageScaleY,
                      int renderFlags,
                      float zoom,
                      const QPointF &bias,
                      const QSizeF pageSize,
                      const int pageIndex,
                      const QSharedPointer<PdfDocumentHolder> &documentHolder,
                      const QFutureInterface<QSharedPointer<QImage>> &interface);
    ~PdfPageRenderPartTask();

    void run() override;
    void cancel() override;
    int id() const override;

private:
    float m_pageScaleX;
    float m_pageScaleY;
    int m_renderFlags;
    float m_zoom;
    QPointF m_bias;
    QSizeF m_pageSize;
    int m_pageIndex;
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    QSharedPointer<QImage> m_image;
    QFutureInterface<QSharedPointer<QImage>> m_interface;
};

#endif // PDFPAGERENDERTASK_H
