// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTRENAMEBOOKMARKSFILETASK_H
#define PDFDOCUMENTRENAMEBOOKMARKSFILETASK_H

#include <QSharedPointer>
#include <QFuture>

#include "pdftask.h"

class PdfDocumentHolder;

/*!
 * \brief The PdfDocumentRenameBookmarksFileTask class describes the task
 * that updates user bookmarks file name.
 */
class PdfDocumentRenameBookmarksFileTask : public PdfTask
{
public:
    PdfDocumentRenameBookmarksFileTask(const QFutureInterface<bool> &interface,
                                       const QSharedPointer<PdfDocumentHolder> &document,
                                       const QString &prevFileName,
                                       const QString &newFileName);
    ~PdfDocumentRenameBookmarksFileTask() = default;

    void run() override;
    void cancel() override;
    int id() const override;

private:
    QFutureInterface<bool> m_interface;
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    QString m_previousFileName;
    QString m_newFileName;
};

#endif // PDFDOCUMENTRENAMEBOOKMARKSFILETASK_H
