// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTPHRASESEARCHTASK_H
#define PDFDOCUMENTPHRASESEARCHTASK_H

#include "pdftask.h"
#include "pdfword.h"
#include "pdfdocumentholder.h"
#include "pdfannotation.h"
#include "pdftaskqueue.h"

#include <QFuture>
#include <QColor>
#include <pdfpagetexts.h>

#include <pdfium/fpdf_text.h>
#include <pdfium/fpdf_annot.h>

class PdfDocumentPhraseSearchTask : public PdfTask
{
public:
    explicit PdfDocumentPhraseSearchTask(const QString phrase, PdfPageTexts *pageTextsModel,
                                         const QFutureInterface<PdfPageTexts*> &interface,
                                         const QSharedPointer<PdfDocumentHolder> &documentHolder);

    PdfDocumentPhraseSearchTask(const QString phrase,
                             const QFutureInterface<PdfPageTexts*> &interface,
                             const QSharedPointer<PdfDocumentHolder> &documentHolder);

    ~PdfDocumentPhraseSearchTask();

    void run() override;
    void cancel() override;
    int id() const override;

private:
    QString getPhraseContext(const int& amountOfCharacters, const FPDF_TEXTPAGE page, const int& startIndex, const QString textWithColloredPhrase, const int wordLength);
    void cacheAndFind(const int& pageIndex, const FPDF_WIDESTRING& phrase);
    QVariant getAnnotationValue(FPDF_ANNOTATION currentAnnot, QString key);
    void findOnCachedPage(const int &pageIndex, const FPDF_WIDESTRING &phrase);
    void findOnPage(const int& pageIndex, const FPDF_WIDESTRING& phrase);

private:
    QFutureInterface<PdfPageTexts*> m_interface;
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    QString m_phrase;
    QVector<QSharedPointer<PdfWord>> m_phrasesForModel;
    QColor m_searchAnnotColor = QColor(Qt::GlobalColor::green);
    QSet<int> m_oldResultByPage;
    PdfPageTexts *m_pageTextsModel;
};

#endif // PDFDOCUMENTPHRASESEARCHTASK_H
