// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTIDLOADTASK_H
#define PDFDOCUMENTIDLOADTASK_H

#include <QSharedPointer>
#include <QFuture>
#include <QString>

#include "pdftask.h"

class PdfDocumentHolder;
class PdfDocumentIdLoadTask : public PdfTask
{
public:
    PdfDocumentIdLoadTask(const QSharedPointer<PdfDocumentHolder> &documentHolder,
                          const QFutureInterface<QString> &interface);
    ~PdfDocumentIdLoadTask() = default;

    void run() override;
    void cancel() override;
    int id() const override;

private:
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    QFutureInterface<QString> m_interface;
    QString m_fileId;
};

#endif // PDFDOCUMENTIDLOADTASK_H
