// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTEXTRACTNEWFILEIDTASK_H
#define PDFDOCUMENTEXTRACTNEWFILEIDTASK_H

#include <QSharedPointer>
#include <QFutureInterface>

#include "pdftask.h"
class PdfDocumentExtractNewFileIdTask : public PdfTask
{
public:
    PdfDocumentExtractNewFileIdTask(const QString &filePath,
                                    const QFutureInterface<QString> &interface);
    ~PdfDocumentExtractNewFileIdTask() = default;

    void run() override;
    void cancel() override;
    int id() const override;

private:
    QString m_path;
    QFutureInterface<QString> m_interface;
};

#endif // PDFDOCUMENTEXTRACTNEWFILEIDTASK_H
