// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTDELETEUSERBOOKMARKTASK_H
#define PDFDOCUMENTDELETEUSERBOOKMARKTASK_H

#include <QFuture>
#include <QSharedPointer>

#include "pdftask.h"

class PdfDocumentHolder;
class PdfDocumentDeleteUserBookmarkTask : public PdfTask
{
public:
    PdfDocumentDeleteUserBookmarkTask(int pageNumber,
                                  const QString &fileName,
                                  const QFutureInterface<bool> &interface,
                                  const QSharedPointer<PdfDocumentHolder> &document);
    ~PdfDocumentDeleteUserBookmarkTask() = default;

    void run() override;
    void cancel() override;
    int id() const override;

private:
    QFutureInterface<bool> m_interface;
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    int m_pageNumber;
    QString m_fileName;
};

#endif // PDFDOCUMENTDELETEUSERBOOKMARKTASK_H
