#ifndef PDFPAGETEXTS_H
#define PDFPAGETEXTS_H

#include <QObject>
#include <QRegularExpressionMatchIterator>
#include <QSharedPointer>
#include <QVector>
#include "pdfword.h"

class PdfPageTexts : public QObject
{
    Q_OBJECT

public:
    explicit PdfPageTexts(QObject *parent = nullptr);

    bool isEmpty() const;
    bool hasPage(int pageIndex) const;
    int size() const;
    void addPage(int index, QString pageText);
    void addResult(QSharedPointer<PdfWord> result);
    const QHash<int, QString> &pageTexts() const;
    void addLastSearchResult(QVector<QSharedPointer<PdfWord>> res);
    QRegularExpressionMatchIterator findTextOnPage(int pageIntex, QString text);

    const QVector<QSharedPointer<PdfWord> > &phrasesForModel() const;
private:
    QString m_phrase;
    QVector<QSharedPointer<PdfWord>> m_phrasesForModel;
    QHash<int, QString> m_pageTexts;
};

#endif // PDFPAGETEXTS_H
