// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef FILEUTILS_H
#define FILEUTILS_H

#include <QObject>

class QQmlEngine;
class QJSEngine;

class FileUtils : public QObject
{
    Q_OBJECT
public:
    static void registerSingleton(const char *uri);
    static QObject *singletonProvider(QQmlEngine *engine, QJSEngine *);

    Q_INVOKABLE QString absoluteFilePathFromUrl(const QUrl &url);

private:
    explicit FileUtils(QObject *parent = nullptr);
};

#endif // FILEUTILS_H
