// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef USERBOOKMARKSMODEL_H
#define USERBOOKMARKSMODEL_H

#include <QAbstractListModel>
#include <QVector>

struct UserBookmark;
class UserBookmarksModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum FilePropertyRoles
    {
        LevelRole = Qt::UserRole + 1,
        PageNumberRole,
        PageTextRole
    };

    explicit UserBookmarksModel(QObject *parent = nullptr);

    int rowCount(const QModelIndex &parent) const override;
    QVariant data(const QModelIndex &index, int role) const override;
    QHash<int, QByteArray> roleNames() const override;
    void setNewData(const QVector<UserBookmark *> &newData);
    bool isPageBookmarked(int pageIndex);

private:
    QVector<UserBookmark *> m_data;
};

#endif // USERBOOKMARKSMODEL_H
