// SPDX-FileCopyrightText: 2022-2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFSIMPLENOTE_H
#define PDFSIMPLENOTE_H

#include <QQuickItem>
#include <QImage>

#define TEXT_SEARCH_AUTHOR "TEXT_SEARCH"

class QSGTexture;
class BaseAnnotation;
class PdfSimpleNote : public QQuickItem
{
    Q_OBJECT
public:
    PdfSimpleNote(QQuickItem *parent, QSharedPointer<BaseAnnotation> source);
    ~PdfSimpleNote();
    QSGNode *updatePaintNode(QSGNode *oldNode, UpdatePaintNodeData *) override;

    QSharedPointer<BaseAnnotation> source() const;
    void setColor(QColor color);
    void resetColor();
    bool isSearchResult();
    QPointF getHighlightStartCoords();

public slots:
    bool event(QEvent *event) override;
    void clearHighlight();

signals:
    void triggered(QString, QString, int, QColor, QString);

private:
    void _setHighlight(bool highlight);
    QImage _prepareTexture(int alpha);

private:
    bool m_highlighted;
    bool m_needUpdateImage;
    quint16 m_padding;
    QImage m_paper;
    QImage m_HighlightedPaper;
    QSharedPointer<BaseAnnotation> m_noteSource;
    bool m_isOverrideDefaultColor;
    QColor m_color;
};

#endif // PDFSIMPLENOTE_H
