// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFSEARCHRESULTSREMOVER_H
#define PDFSEARCHRESULTSREMOVER_H

#include <QObject>
#include <QRunnable>
#include <baseword.h>
#include <amberpdf/pdfdocument.h>
#include <pdfdocumentitem.h>


class PdfSearchResultsRemover : public QObject, public QRunnable
{
    Q_OBJECT
public:
    PdfSearchResultsRemover(QSharedPointer<PdfDocument> pdfiumDocument);
    void run() override;

signals:
    void done();

private:
    QSharedPointer<PdfDocument> m_pdfiumDocument;
};

#endif // PDFSEARCHRESULTSREMOVER_H
