// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include "pdfsearchresultsremover.h"

PdfSearchResultsRemover::PdfSearchResultsRemover(QSharedPointer<PdfDocument> pdfiumDocument)
{
    m_pdfiumDocument = pdfiumDocument;
}

void PdfSearchResultsRemover::run()
{
    const int pageCount = m_pdfiumDocument->pageCount();
    for (int i = 0; i < pageCount; ++i) {
         QSharedPointer<PdfPage> page = m_pdfiumDocument->page(i).result();
         page->removeTextSearchResult().waitForFinished();
    }
    emit done();
}

