// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTHASHWORKER_H
#define PDFDOCUMENTHASHWORKER_H

#include <QObject>
#include <QRunnable>

/*!
 * \brief The PdfDocumentHashWorker class counts hash sum
 * for the given pdf file.
 */
class PdfDocumentHashWorker : public QObject, public QRunnable
{
    Q_OBJECT
public:
    PdfDocumentHashWorker(const QString &filePath);
    void run() override;

signals:
    void fileHashCounted(const QString &fileHash);

private:
    QString m_filePath;
};

#endif // PDFDOCUMENTHASHWORKER_H
