// SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef BASEWORD_H
#define BASEWORD_H

#include <QPointF>
#include <QRectF>
#include <QString>
#include <QList>

struct BaseWord
{
    QString value;
    int pageIndex {-1};
    QRectF rect;
    QList<QRectF> attachedRects;
    QString context;

    BaseWord(QString value, int pageIndex, QRectF rect, QList<QRectF> attachedRects = QList<QRectF>(), QString context = "") {
        this->value = value;
        this->pageIndex = pageIndex;
        this->rect = rect;
        this->attachedRects = attachedRects;
        this->context = context;
    }
};

#endif // BASEWORD_H
