// SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef BASEANNOTATION_H
#define BASEANNOTATION_H

#include <QRectF>
#include <QString>
#include <QColor>

static QList<QString> s_stringTypeValues = QList<QString>()  << "Unknown"
 << "Text"
 << "Link"
 << "Freetext"
 << "Line"
 << "Square"
 << "Circle"
 << "Polygon"
 << "Polyline"
 << "HighLight"
 << "Underline"
 << "Squiggly"
 << "Strikeout"
 << "Stamp"
 << "Caret"
 << "Ink"
 << "Popup"
 << "Fileattachment"
 << "Sound"
 << "Movie"
 << "Widget"
 << "Screen"
 << "Printermark"
 << "Trapnet"
 << "Watermark"
 << "Threed"
 << "Richmedia"
 << "Xfawidget"
 << "Redact"
 << "Url";

struct BaseAnnotation
{
public:
    enum class AnnotationType
    {
        Unknown = 0,
        Text,
        Link,
        Freetext,
        Line,
        Square,
        Circle,
        Polygon,
        Polyline,
        HighLight,
        Underline,
        Squiggly,
        Strikeout,
        Stamp,
        Caret,
        Ink,
        Popup,
        Fileattachment,
        Sound,
        Movie,
        Widget,
        Screen,
        Printermark,
        Trapnet,
        Watermark,
        Threed,
        Richmedia,
        Xfawidget,
        Redact,
        Url
    };

    AnnotationType type;
    QRectF rect;
    QString author;
    QString content;
    int linkToPage;
    QPointF pageCoordinate;
    QList<QList<QPointF>> pointLists;
    qreal lineWidth;
    QColor color{Qt::white};
    int annotationId;
    bool isSearchResult;
    QList<QRectF> attachedPoints;

    QString getTypeAsString() const;
};

#endif // BASEANNOTATION_H
