// SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include "interface/basebookmark.h"
#include "chaptersmodel.h"

ChaptersModel::ChaptersModel(QObject *parent) : QAbstractListModel(parent) {  }

int ChaptersModel::rowCount(const QModelIndex &parent) const
{
    return parent.isValid() ? 0 : m_data.size();
}

QVariant ChaptersModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid() || index.row() >= m_data.size())
        return {  };

    const auto *chapter = m_data.at(index.row());
    if (chapter == nullptr)
        return {  };

    switch (role) {
    case LevelRole : return QVariant::fromValue(chapter->level);
    case TitleRole: return QVariant::fromValue(chapter->title);
    case PageIndexRole: return QVariant::fromValue(chapter->pageIndex);
    case InPageXRole: return QVariant::fromValue(chapter->positionInPage.x());
    case InPageYRole: return QVariant::fromValue(chapter->positionInPage.y());
    }

    return {  };
}

QHash<int, QByteArray> ChaptersModel::roleNames() const
{
    return {
        { LevelRole, "level" },
        { TitleRole, "title" },
        { PageIndexRole, "pageIndex" },
        { InPageXRole, "pageX" },
        { InPageYRole, "pageY" }
    };
}

void ChaptersModel::setNewData(const QVector<BaseBookmark *> &newData)
{
    beginResetModel();
    m_data.clear();
    m_data = newData;
    endResetModel();
}
