// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTUSERBOOKMARKSLOADTASK_H
#define PDFDOCUMENTUSERBOOKMARKSLOADTASK_H

#include <QSharedPointer>
#include <QFuture>
#include <QString>
#include <QVector>

#include "pdftask.h"
#include "userpdfbookmark.h"

class PdfDocumentHolder;
struct UserPdfBookmark;

/*!
 * \brief Task for loading user bookmarks.
 */
class PdfDocumentUserBookmarksLoadTask: public PdfTask
{
public:
    PdfDocumentUserBookmarksLoadTask(const QSharedPointer<PdfDocumentHolder> &documentHolder,
                                       const QFutureInterface<QVector<UserPdfBookmark>> &interface,
                                       const QString &fileName);
    ~PdfDocumentUserBookmarksLoadTask() = default;

    void run() override;
    void cancel() override;
    int id() const override;

private:
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
    QFutureInterface<QVector<UserPdfBookmark>> m_interface;
    QVector<UserPdfBookmark> m_bookmarks;
    QString m_fileName;
};

#endif // PDFDOCUMENTUSERBOOKMARKSLOADTASK_H
