// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef PDFDOCUMENTADDUSERBOOKMARKTASK_H
#define PDFDOCUMENTADDUSERBOOKMARKTASK_H

#include <QFuture>
#include <QSharedPointer>

#include "pdftask.h"

class PdfDocumentHolder;
class PdfDocumentAddUserBookmarkTask : public PdfTask
{
public:
    struct NewBookmark
    {
        int pageIndex;
        QString pageText;
        QString fileName;
    };

public:
    PdfDocumentAddUserBookmarkTask(const NewBookmark &newBookmark,
                             const QFutureInterface<bool> &interface,
                             const QSharedPointer<PdfDocumentHolder> &document);
    ~PdfDocumentAddUserBookmarkTask() = default;

    void run() override;
    void cancel() override;
    int id() const override;

private:
    NewBookmark m_newBookmark;
    QFutureInterface<bool> m_interface;
    QSharedPointer<PdfDocumentHolder> m_documentHolder;
};

#endif // PDFDOCUMENTADDUSERBOOKMARKTASK_H
