#include "pdfpagetexts.h"

PdfPageTexts::PdfPageTexts(QObject *parent) : QObject(parent) { }

bool PdfPageTexts::isEmpty() const
{
    return m_pageTexts.isEmpty();
}

bool PdfPageTexts::hasPage(int pageIndex) const
{
    return m_pageTexts.contains(pageIndex);
}

int PdfPageTexts::size() const
{
    return m_pageTexts.size();
}

void PdfPageTexts::addPage(int index, QString pageText)
{
    m_pageTexts.insert(index, pageText);
}

void PdfPageTexts::addResult(QSharedPointer<PdfWord> result)
{
    m_phrasesForModel.append(result);
}

const QHash<int, QString> &PdfPageTexts::pageTexts() const
{
    return m_pageTexts;
}

void PdfPageTexts::addLastSearchResult(QVector<QSharedPointer<PdfWord>> res)
{
    m_phrasesForModel.clear();
    m_phrasesForModel.append(res);
}

QRegularExpressionMatchIterator PdfPageTexts::findTextOnPage(int pageIntex, QString text)
{
    QRegularExpression regex(text, QRegularExpression::CaseInsensitiveOption);

    return regex.globalMatch(m_pageTexts.value(pageIntex));
}

const QVector<QSharedPointer<PdfWord> > &PdfPageTexts::phrasesForModel() const
{
    return m_phrasesForModel;
}
