# Просмотрщик PDF

## Описание

Проект предоставляет пример программы для просмотра PDF-документов.  
Приложение состоит из четырех частей:
1. Библиотека **[PDFium](https://gitverse.ru/auroraos/mirror_pdfium)**, которая предоставляет API для работы с PDF документами.
2. Библиотека **[AmberPDF](https://hub.mos.ru/auroraos/libraries/amberpdf)** представляет собой обертку для PDFium, которая позволяет использовать ее в Qt.
3. Плагин **[AmberPDF QML Plugin](https://hub.mos.ru/auroraos/libraries/amberpdf-qml-plugin)** используется для отображения PDF-документов на движке QML. В качестве бэкенда рендеринга он зависит от библиотеки AmberPDF.
4. Приложение для просмотра PDF документов.
  
Приложение позволяет открывать PDF документы в полноэкранном режиме. При нажатии на нумерацию идет переход на страницу, на которой есть оглавление PDF документа и возможность 
переходить на выбранную страницу. Кнопка настроек, расположенная справа на нижней панели, открывает попап и имеет следующие функции: горизонтальная режим работы,
возможность поделиться файлом, поиск по слову и сохранить документ. Добавлена работа с аннотациями, например - просмотр, добавление, редактирование и удаление.
Попап для работы с аннотациями открывается при нажатии на кнопку, расположенную слева на нижней панели. После редактирования аннотаций нужно сохранить документ.

## Условия использования и участия

Исходный код проекта предоставляется по [лицензии](LICENSE.BSD-3-Clause.md),
которая позволяет использовать его в сторонних приложениях.

[Соглашение участника](CONTRIBUTING.md) регламентирует права,
предоставляемые участниками компании «Открытая Мобильная Платформа».

Информация об участниках указана в файле [AUTHORS](AUTHORS.md).

[Кодекс поведения](CODE_OF_CONDUCT.md) — это действующий набор правил
компании «Открытая Мобильная Платформа»,
который информирует об ожиданиях по взаимодействию между членами сообщества при общении и работе над проектами.

## Структура проекта

* Файл **[CMakeLists.txt](CMakeLists.txt)** описывает структуру проекта для системы сборки CMake.
* Каталог **[amberpdf](amberpdf)** содержит библиотеку [AmberPDF](https://hub.mos.ru/auroraos/libraries/amberpdf).
* Каталог **[amberpdfqmlplugin](amberpdfqmlplugin)** содержит плагин [AmberPDF QML Plugin](https://hub.mos.ru/auroraos/libraries/amberpdf-qml-plugin).
* Каталог **[application](application)** содержит приложение PdfViewer.
  * Каталог **[data](application/data)** содержит данные для приложения, например pdf документы.
  * Каталог **[icons](application/icons)** содержит иконки приложения для поддерживаемых разрешений экрана.
  * Каталог **[qml](application/qml)** содержит исходный код на QML и ресурсы интерфейса пользователя.
    * Каталог **[assets](application/qml/assets)** содержит дополнительные иконки интерфейса пользователя.
    * Каталог **[components](application/qml/components)** содержит дополнительные компоненты QML.
    * Каталог **[cover](application/qml/cover)** содержит реализации обложек приложения.
    * Каталог **[pages](application/qml/pages)** содержит страницы приложения.
    * Файл **[ru.auroraos.PdfViewer.qml](application/qml/ru.auroraos.PdfViewer.qml)** предоставляет реализацию окна приложения.
  * Каталог **[src](application/src)** содержит исходный код C++.
  * Каталог **[translations](application/translations)** содержит файлы перевода пользовательского интерфейса.
  * Файл **[CMakeLists.txt](application/CMakeLists.txt)** описывает структуру проекта PdfViewer для системы сборки CMake.
  * Файл **[ru.auroraos.PdfViewer.desktop](application/ru.auroraos.PdfViewer.desktop)** определяет отображение и параметры для запуска приложения.
* Каталог **[pdfium](pdfium)** содержит библиотеку [PDFium](https://gitverse.ru/auroraos/mirror_pdfium).
* Каталог **[rpm](rpm)** содержит настройки сборки rpm-пакета.
  * Файл **[ru.auroraos.PdfViewer.spec](rpm/ru.auroraos.PdfViewer.spec)** используется инструментом rpmbuild.

## Снимки экранов

![screenshots](screenshots/screenshots.png)

## This document in English

- [README.md](README.md)
