# PDF Viewer

## Description

The project provides an example of a program for viewing PDF documents.  
The application consists of four parts:
1. The **[PDFium](https://gitverse.ru/auroraos/mirror_pdfium)** library, which provides an API for working with PDF documents.
2. The **[AmberPDF](https://hub.mos.ru/auroraos/libraries/amberpdf)** library is a wrapper for PDFium that allows it to be used in Qt.
3. The **[AmberPDF QML Plugin](https://hub.mos.ru/auroraos/libraries/amberpdf-qml-plugin)** is used to render PDF documents using the QML engine. It depends on the AmberPDF library as a rendering backend.
4. PDF document viewer application.
  
The application allows you to open PDF documents in full screen mode. If you click on the numbering, you will be taken to a page that has the table of contents of the PDF document and the ability to go to the selected page. 
to go to the selected page. The settings button, located on the right side of the bottom panel, opens the popup and has the following functions: horizontal mode,
the ability to share the file, word search and save the document. Annotation handling has been added, such as - view, add, edit and delete.
The popup for working with annotations is opened by clicking on the button located on the left side of the bottom panel. After editing annotations you need to save the document.

## Terms of Use and Participation

The source code of the project is provided under [the license](LICENSE.BSD-3-Clause.md),
that allows it to be used in third-party applications.

The [contributor agreement](CONTRIBUTING.md) documents the rights granted by contributors
to the Open Mobile Platform.

For information about contributors see [AUTHORS](AUTHORS.md).

[Code of conduct](CODE_OF_CONDUCT.md) is a current set of rules of the Open Mobile
Platform which informs you how we expect the members of the community will interact
while contributing and communicating.

## Project Structure

* **[CMakeLists.txt](CMakeLists.txt)** the file describes the project structure for the CMake build system.
* **[amberpdf](amberpdf)** the directory contains the [AmberPDF](https://hub.mos.ru/auroraos/libraries/amberpdf) library.
* **[amberpdfqmlplugin](amberpdfqmlplugin)** the directory contains the [AmberPDF QML Plugin](https://hub.mos.ru/auroraos/libraries/amberpdf-qml-plugin) plugin.
* **[application](application)** the directory contains the PdfViewer application.
  * **[data](application/data)** the directory contains data for the application, such as pdf documents.
  * **[icons](application/icons)** the directory contains application icons for supported screen resolutions.
  * **[qml](application/qml)** the directory contains QML source code and user interface resources.
    * **[assets](application/qml/assets)** the directory contains additional user interface icons.
    * **[components](application/qml/components)** the directory contains additional QML components.
    * **[cover](application/qml/cover)** the directory contains implementations of application covers.
    * **[pages](application/qml/pages)** the directory contains application pages.
    * **[ru.auroraos.PdfViewer.qml](application/qml/ru.auroraos.PdfViewer.qml)** the file provides an implementation of the application window.
  * **[src](application/src)** the directory contains the C++ source code.
  * **[translations](application/translations)** the directory contains the user interface translation files.
  * **[CMakeLists.txt](application/CMakeLists.txt)** the file describes the structure of the PdfViewer project for the CMake build system.
  * **[ru.auroraos.PdfViewer.desktop](application/ru.auroraos.PdfViewer.desktop)** the file defines the display and options for running the application.
* **[pdfium](pdfium)** the directory contains the [PDFium](https://gitverse.ru/auroraos/mirror_pdfium) library.
* **[rpm](rpm)** the directory contains the rpm package build settings.
  * **[ru.auroraos.PdfViewer.spec](rpm/ru.auroraos.PdfViewer.spec)** the file is used by the rpmbuild tool.

## Screenshots

![screenshots](screenshots/screenshots.png)

## This document in Russian / Перевод этого документа на русский язык

- [README.ru.md](README.ru.md)
