/*******************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
** This file is part of the OfficeViewer project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/


import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

Rectangle {
    property bool processing
    property alias text: label.text
    property bool _show

    onProcessingChanged: {
        if (processing) {
            _show = true
            timer.stop()
        } else {
            timer.start()
        }
    }

    color: Theme.darkPrimaryColor
    width: parent.width
    height: _show ? label.height + Theme.paddingMedium : 0
    opacity: _show ? 1.0 : 0.0

    Behavior on height { NumberAnimation { duration:  300 } }
    Behavior on opacity { FadeAnimation { } }

    BusyIndicator {
        id: indicator

        anchors {
            left: parent.left
            leftMargin: Theme.paddingLarge * 2
            verticalCenter: parent.verticalCenter
        }

        running: _show
        size: BusyIndicatorSize.Small
        color: Theme.lightPrimaryColor
    }

    Label {
        id: label

        anchors {
            left: indicator.right
            leftMargin: Theme.paddingMedium
            verticalCenter: parent.verticalCenter
        }

        color: Theme.lightPrimaryColor
        font.pixelSize: Theme.fontSizeSmall
        //% "Loading"
        text: qsTrId("docviewer-la-processing")
    }

    Timer {
        id: timer

        interval: 1500
        onTriggered: _show = false
    }
}
